-- new script file

local attackLT = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("attLT")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.attackCounter = 0
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
      self.active = false
    end
  
    mission.enemy = Citadels.GetPlayer(1)
    self.attackPoint = Game:GetEntity('P3-thallSP-L1-0'):GetPosition()
  end
  
  if self.active then
    if self.attackCounter > 0 then 
      UpgradeWave(self) 
    end
    InitializeWave(self)
    GenerateWaveAI(self)
    self.attackCounter = self.attackCounter + 1
    self.active = false
  end  
end

function InitializeWave(self)
  attackLT['unit_L_arbalist_L1'] = self.baseCount * 0.04
  attackLT['unit_L_archer_L2'] = self.baseCount * 0.06
  attackLT['unit_L_fman_L1'] = self.baseCount * 0.08
  attackLT['unit_L_rider_L1'] = self.baseCount * 0.02
	if self.attackCounter > 5 then
		attackLT['unit_L_catapult_L1'] = self.baseCount * 0.02
		attackLT['unit_L_fman_L1'] = 0
		attackLT['unit_L_fman_L2'] = self.baseCount * 0.08
	end
end

function UpgradeWave(self)
  self.baseCount = self.baseCount + 10
end

function GenerateWaveAI(self)
  for prefab,ammount in pairs(attackLT) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  --mission.enemy:AttackGroupSetModeToSpawn()
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.attackPoint)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(),20)
  mission.enemy:AttackGroupMaxWaitTimeForUnitsCreation(120)
end

function OnTrigger(self, source, target)
  if target == "attLT" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    OnAfterSceneLoaded(self)
    self.loaded = true
    self.baseCount = ar:Read()
    self.attackCounter = ar:Read()
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.baseCount)
    ar:Write(self.attackCounter)
    ar:Write(self.active)
  end
end
